"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    AuditLogItem: function() {
        return AuditLogItem;
    },
    getAuditMiddleware: function() {
        return getAuditMiddleware;
    }
});
const _logging = require("@tamanu/shared/services/logging");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let AuditLogItem = class AuditLogItem {
    shouldKeep() {
        // any permissions check should be logged
        if (this.permissionChecks.length > 0) return true;
        // or if we've annotated it with anything extra
        if (this.annotations) return true;
        // nothing relevant to log, discard
        return false;
    }
    resolve() {
        // just log to console/honeycomb for now
        _logging.log.info('auditLogEntry', {
            userId: this.userId,
            data: this.annotations,
            perms: this.permissionChecks
        });
    }
    annotate(data) {
        // in the first annotation this.annotations will be null but that's fine
        this.annotations = {
            ...this.annotations,
            ...data
        };
    }
    addPermissionCheck(verb, noun, objectId) {
        this.permissionChecks.push({
            verb,
            noun,
            objectId
        });
    }
    constructor(){
        _define_property(this, "userId", '');
        _define_property(this, "annotations", null);
        _define_property(this, "permissionChecks", []);
    }
};
const auditMiddleware = async (req, res, next)=>{
    const audit = new AuditLogItem();
    req.audit = audit;
    const logsEnabled = _config.default.log.enableAuditLog;
    // only attach the resolver if audit logs are enabled
    // (without this bit, all the audit logs will just be discarded)
    if (logsEnabled) {
        res.on('finish', ()=>{
            audit.userId = req.user?.id;
            if (!audit.shouldKeep()) return;
            audit.resolve();
        });
    }
    next();
};
function getAuditMiddleware() {
    return auditMiddleware;
}

//# sourceMappingURL=auditLog.js.map