import { times } from 'lodash';
import { fake, chance } from '../../fake';
export const createProgramRegistry = async ({ models, userId, patientId, programRegistryId, conditionCount = chance.integer({
    min: 1,
    max: 5
}) })=>{
    const { PatientProgramRegistration, PatientProgramRegistrationCondition } = models;
    await PatientProgramRegistration.create(fake(PatientProgramRegistration, {
        clinicianId: userId,
        patientId,
        programRegistryId
    }));
    times(conditionCount, async ()=>{
        await PatientProgramRegistrationCondition.create(fake(PatientProgramRegistrationCondition, {
            patientId,
            programRegistryId
        }));
    });
};

//# sourceMappingURL=programRegistry.js.map