"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    AuthExpiredError: function() {
        return AuthExpiredError;
    },
    ResourceConflictError: function() {
        return ResourceConflictError;
    },
    ServerResponseError: function() {
        return ServerResponseError;
    },
    ServerUnavailableError: function() {
        return ServerUnavailableError;
    },
    VersionIncompatibleError: function() {
        return VersionIncompatibleError;
    },
    getVersionIncompatibleMessage: function() {
        return getVersionIncompatibleMessage;
    }
});
const _constants = require("@tamanu/constants");
let ServerResponseError = class ServerResponseError extends Error {
};
let AuthExpiredError = class AuthExpiredError extends ServerResponseError {
};
let VersionIncompatibleError = class VersionIncompatibleError extends ServerResponseError {
};
let ServerUnavailableError = class ServerUnavailableError extends Error {
};
let ResourceConflictError = class ResourceConflictError extends ServerResponseError {
};
function getVersionIncompatibleMessage(error, response) {
    if (error.message === _constants.VERSION_COMPATIBILITY_ERRORS.LOW) {
        return 'Tamanu is out of date, reload to get the new version! If that does not work, contact your system administrator.';
    }
    if (error.message === _constants.VERSION_COMPATIBILITY_ERRORS.HIGH) {
        const maxAppVersion = response.headers.get('X-Max-Client-Version').split('.', 3).slice(0, 2).join('.');
        return `The Tamanu Facility Server only supports up to v${maxAppVersion}, and needs to be upgraded. Please contact your system administrator.`;
    }
    return null;
}

//# sourceMappingURL=errors.js.map