"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Bundle", {
    enumerable: true,
    get: function() {
        return Bundle;
    }
});
const _constants = require("@tamanu/constants");
const _fhir = require("@tamanu/shared/utils/fhir");
const _crypto = /*#__PURE__*/ _interop_require_default(require("crypto"));
const _utils = require("../utils");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let Bundle = class Bundle {
    addSelfUrl(req) {
        const baseUrl = (0, _utils.getBaseUrl)(req);
        this.options.selfurl = (0, _utils.getHL7Link)(baseUrl, req.query);
    }
    addIncluded(included) {
        this.included = this.included.concat(included);
    }
    addIssues(issues) {
        this.issues = this.issues.concat(issues);
    }
    get includes() {
        return new Set(this.included.map((r)=>r.fhirName));
    }
    asFhir() {
        const fields = {
            resourceType: 'Bundle',
            id: _crypto.default.randomUUID(),
            type: this.type,
            timestamp: (0, _fhir.formatFhirDate)(new Date())
        };
        if (typeof this.options.total === 'number') {
            fields.total = this.options.total;
        }
        if (this.options.link) {
            fields.link = this.options.link;
        }
        if (this.options.selfurl) {
            var _fields;
            (_fields = fields).link || (_fields.link = []);
            fields.link.push({
                relation: 'self',
                url: this.options.selfurl
            });
        }
        fields.entry = this.resources.map((r)=>resourceToEntry(r, this.isSearchResult ? 'match' : null)).concat(this.included.map((r)=>resourceToEntry(r, this.isSearchResult ? 'include' : null)));
        if (this.issues.length > 0) {
            const oo = new _fhir.OperationOutcome(this.issues);
            oo.downgradeErrorsToWarnings();
            fields.issues = oo.asFhir();
        }
        return fields;
    }
    constructor(type, resources, options = {}){
        _define_property(this, "included", []);
        _define_property(this, "issues", []);
        /** Will be set to true if this is a search result bundle. */ _define_property(this, "isSearchResult", false);
        this.type = type;
        this.resources = resources;
        this.options = options;
        if (type === _constants.FHIR_BUNDLE_TYPES.SEARCHSET) {
            this.isSearchResult = true;
        }
    }
};
function resourceToEntry(resource, searchMode = null) {
    const entry = {
        resource: resource.asFhir()
    };
    if (searchMode) {
        entry.search = {
            mode: searchMode
        };
    }
    return entry;
}

//# sourceMappingURL=bundle.js.map