"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientEmailCommunicationProcessor", {
    enumerable: true,
    get: function() {
        return PatientEmailCommunicationProcessor;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _constants = require("@tamanu/constants");
const _tasks = require("@tamanu/shared/tasks");
const _logging = require("@tamanu/shared/services/logging");
const _files = require("../utils/files");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
// turns 'hello there' into 'h*********e'
const maskMiddle = (s)=>s.slice(0, 1) + s.slice(1, -1).replace(/./g, '*') + s.slice(-1);
// turns 'test@gmail.com' into 't**t@g*******m'
const maskEmail = (email)=>email.replace(/[^@]*/g, maskMiddle);
let PatientEmailCommunicationProcessor = class PatientEmailCommunicationProcessor extends _tasks.ScheduledTask {
    getName() {
        return 'PatientEmailCommunicationProcessor';
    }
    async countQueue() {
        const { PatientCommunication } = this.context.store.models;
        return PatientCommunication.countPendingMessages(_constants.PATIENT_COMMUNICATION_CHANNELS.EMAIL);
    }
    async run() {
        const { Patient, PatientCommunication } = this.context.store.models;
        const emailsToBeSent = await PatientCommunication.getPendingMessages(_constants.PATIENT_COMMUNICATION_CHANNELS.EMAIL, {
            include: [
                {
                    model: Patient,
                    as: 'patient'
                }
            ],
            limit: this.config.limit
        });
        const sendEmails = emailsToBeSent.map(async (email)=>{
            const emailPlain = email.get({
                plain: true
            });
            const toAddress = emailPlain.destination || emailPlain.patient?.email;
            _logging.log.info('Sending email to patient', {
                communicationId: emailPlain.id,
                type: emailPlain.type,
                patientId: emailPlain.patient?.id,
                email: toAddress ? maskEmail(toAddress) : null
            });
            const result = await this.context.emailService.sendEmail({
                to: toAddress,
                from: _config.default.mailgun.from,
                subject: emailPlain.subject,
                text: emailPlain.content,
                attachment: emailPlain.attachment
            });
            if (result.error) {
                _logging.log.warn('Email failed', {
                    communicationId: emailPlain.id,
                    error: result.error
                });
            }
            if (result.shouldRetry) {
                return email.update({
                    retryCount: emailPlain.retryCount + 1,
                    error: result.error
                });
            }
            if (emailPlain.attachment) await (0, _files.removeFile)(emailPlain.attachment);
            return email.update({
                status: result.status,
                error: result.error
            });
        });
        return Promise.all(sendEmails);
    }
    constructor(context){
        const conf = _config.default.schedules.patientEmailCommunicationProcessor;
        const { schedule, jitterTime, enabled } = conf;
        super(schedule, _logging.log, jitterTime, enabled);
        this.config = conf;
        this.context = context;
    }
};

//# sourceMappingURL=PatientEmailCommunicationProcessor.js.map