"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientAllergy", {
    enumerable: true,
    get: function() {
        return PatientAllergy;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _dateTime = require("@tamanu/utils/dateTime");
const _Model = require("./Model");
const _buildPatientSyncFilterViaPatientId = require("../sync/buildPatientSyncFilterViaPatientId");
const _buildPatientLinkedLookupFilter = require("../sync/buildPatientLinkedLookupFilter");
const _model = require("../types/model");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let PatientAllergy = class PatientAllergy extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            note: _sequelize.DataTypes.STRING,
            recordedDate: (0, _model.dateTimeType)('recordedDate', {
                defaultValue: _dateTime.getCurrentDateTimeString,
                allowNull: false
            })
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId'
        });
        this.belongsTo(models.User, {
            foreignKey: 'practitionerId'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'allergyId',
            as: 'allergy'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'reactionId',
            as: 'reaction'
        });
    }
    static getListReferenceAssociations() {
        return [
            'allergy',
            'reaction'
        ];
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildPatientLinkedLookupFilter.buildPatientLinkedLookupFilter)(this);
    }
};
_define_property(PatientAllergy, "buildPatientSyncFilter", _buildPatientSyncFilterViaPatientId.buildPatientSyncFilterViaPatientId);

//# sourceMappingURL=PatientAllergy.js.map