import { fake } from '../../fake';
export const createTask = async ({ models, encounterId, userId, referenceDataId })=>{
    const { Task, TaskDesignation, TaskTemplate, TaskTemplateDesignation, UserDesignation } = models;
    const task = await Task.create(fake(Task, {
        encounterId,
        requestedByUserId: userId,
        completedByUserId: userId,
        notCompletedByUserId: userId,
        notCompletedReasonId: referenceDataId,
        todoByUserId: userId,
        deletedByUserId: userId,
        deletedReasonId: referenceDataId
    }));
    await TaskDesignation.create(fake(TaskDesignation, {
        taskId: task.id,
        designationId: referenceDataId
    }));
    const taskTemplate = await TaskTemplate.create(fake(TaskTemplate, {
        referenceDataId
    }));
    await TaskTemplateDesignation.create(fake(TaskTemplateDesignation, {
        taskTemplateId: taskTemplate.id,
        designationId: referenceDataId
    }));
    await UserDesignation.create(fake(UserDesignation, {
        userId,
        designationId: referenceDataId
    }));
};

//# sourceMappingURL=tasking.js.map