"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientIssue", {
    enumerable: true,
    get: function() {
        return PatientIssue;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _dateTime = require("@tamanu/utils/dateTime");
const _Model = require("./Model");
const _buildPatientSyncFilterViaPatientId = require("../sync/buildPatientSyncFilterViaPatientId");
const _buildPatientLinkedLookupFilter = require("../sync/buildPatientLinkedLookupFilter");
const _model = require("../types/model");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
const PATIENT_ISSUE_TYPE_VALUES = Object.values(_constants.PATIENT_ISSUE_TYPES);
let PatientIssue = class PatientIssue extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            note: _sequelize.DataTypes.STRING,
            recordedDate: (0, _model.dateTimeType)('recordedDate', {
                defaultValue: _dateTime.getCurrentDateTimeString,
                allowNull: false
            }),
            type: {
                type: _sequelize.DataTypes.ENUM(...PATIENT_ISSUE_TYPE_VALUES),
                defaultValue: _constants.PATIENT_ISSUE_TYPES.ISSUE,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId'
        });
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildPatientLinkedLookupFilter.buildPatientLinkedLookupFilter)(this);
    }
};
_define_property(PatientIssue, "buildPatientSyncFilter", _buildPatientSyncFilterViaPatientId.buildPatientSyncFilterViaPatientId);

//# sourceMappingURL=PatientIssue.js.map