import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
export class RefreshToken extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            refreshId: {
                type: DataTypes.TEXT,
                allowNull: false
            },
            deviceId: {
                type: DataTypes.TEXT,
                allowNull: false
            },
            expiresAt: {
                type: DataTypes.DATE,
                allowNull: false
            }
        }, {
            indexes: [
                {
                    name: 'refresh_tokens_user_id_device_id',
                    fields: [
                        'user_id',
                        'device_id'
                    ],
                    unique: true
                }
            ],
            ...options,
            syncDirection: SYNC_DIRECTIONS.DO_NOT_SYNC
        });
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'userId'
        });
    }
}

//# sourceMappingURL=RefreshToken.js.map