"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "changePassword", {
    enumerable: true,
    get: function() {
        return changePassword;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _sequelize = require("sequelize");
const _sync = require("../../sync");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const changePassword = _express.default.Router();
changePassword.post('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    // no permission needed
    req.flagPermissionChecked();
    const { models, deviceId } = req;
    const centralServer = new _sync.CentralServerConnection({
        deviceId
    });
    const response = await centralServer.forwardRequest(req, 'changePassword');
    // If central server successful, update password on facility server too
    await updatePasswordOnFacilityServer(models, req.body);
    res.send(response);
}));
changePassword.post('/validate-reset-code', (0, _expressasynchandler.default)(async (req, res)=>{
    req.flagPermissionChecked();
    const { deviceId } = req;
    const centralServer = new _sync.CentralServerConnection({
        deviceId
    });
    const response = await centralServer.forwardRequest(req, 'changePassword/validate-reset-code');
    res.send(response);
}));
const updatePasswordOnFacilityServer = async (models, { email, newPassword })=>{
    await models.User.update({
        password: newPassword
    }, {
        where: _sequelize.Sequelize.where(_sequelize.Sequelize.fn('lower', _sequelize.Sequelize.col('email')), _sequelize.Sequelize.fn('lower', email))
    });
};

//# sourceMappingURL=changePassword.js.map