"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "makePatientLetter", {
    enumerable: true,
    get: function() {
        return makePatientLetter;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = /*#__PURE__*/ _interop_require_default(require("@react-pdf/renderer"));
const _path = /*#__PURE__*/ _interop_require_default(require("path"));
const _lodash = require("lodash");
const _utils = require("@tamanu/shared/utils");
const _crypto = /*#__PURE__*/ _interop_require_default(require("crypto"));
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const makePatientLetter = async (req, { id, facilityId, ...data })=>{
    const { getLocalisation, models, language, settings } = req;
    const localisation = await getLocalisation();
    const getLocalisationData = (key)=>(0, _lodash.get)(localisation, key);
    const letterheadConfig = await settings[facilityId].get(_constants.SETTING_KEYS.TEMPLATES_LETTERHEAD, facilityId);
    const logo = await models.Asset.findOne({
        raw: true,
        where: {
            name: 'letterhead-logo'
        }
    });
    const folder = await (0, _utils.tmpdir)();
    const fileName = `patient-letter-${id}-${_crypto.default.randomUUID()}.pdf`;
    const filePath = _path.default.join(folder, fileName);
    await _renderer.default.render(/*#__PURE__*/ _react.default.createElement(_utils.PatientLetter, {
        getLocalisation: getLocalisationData,
        data: data,
        logoSrc: logo?.data,
        letterheadConfig: letterheadConfig,
        language: language
    }), filePath);
    return {
        filePath,
        mimeType: 'application/pdf'
    };
};

//# sourceMappingURL=makePatientLetter.js.map