"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "generateEachDataType", {
    enumerable: true,
    get: function() {
        return generateEachDataType;
    }
});
const _helpers = require("./helpers");
const generateEachDataType = async (models)=>{
    // Create one of each basic deployment/reference data to reference for clinical data
    const { referenceData, facility, department, locationGroup, location, survey, scheduledVaccine, invoiceProduct, labTestType, user, programRegistry } = await (0, _helpers.generateImportData)(models);
    // Clinical data
    const { patient } = await (0, _helpers.createPatient)({
        models,
        facilityId: facility.id,
        userId: user.id
    });
    const { encounter } = await (0, _helpers.createEncounter)({
        models,
        patientId: patient.id,
        departmentId: department.id,
        locationId: location.id,
        userId: user.id,
        referenceDataId: referenceData.id
    });
    await Promise.all([
        await (0, _helpers.createLabRequest)({
            models,
            departmentId: department.id,
            userId: user.id,
            encounterId: encounter.id,
            referenceDataId: referenceData.id,
            patientId: patient.id,
            labTestTypeId: labTestType.id
        }),
        await (0, _helpers.createProgramRegistry)({
            models,
            userId: user.id,
            patientId: patient.id,
            programRegistryId: programRegistry.id
        }),
        await (0, _helpers.createSurveyResponse)({
            models,
            encounterId: encounter.id,
            surveyId: survey.id
        }),
        await (0, _helpers.createDbReport)({
            models,
            userId: user.id
        }),
        await (0, _helpers.createAdministeredVaccine)({
            models,
            scheduledVaccineId: scheduledVaccine.id,
            encounterId: encounter.id
        }),
        await (0, _helpers.createInvoice)({
            models,
            encounterId: encounter.id,
            userId: user.id,
            referenceDataId: referenceData.id,
            productId: invoiceProduct.id
        }),
        await (0, _helpers.createImagingRequest)({
            models,
            userId: user.id,
            encounterId: encounter.id,
            locationGroupId: locationGroup.id
        }),
        await (0, _helpers.createRepeatingAppointment)({
            models,
            locationGroupId: locationGroup.id,
            patientId: patient.id,
            clinicianId: user.id
        }),
        await (0, _helpers.createTask)({
            models,
            encounterId: encounter.id,
            userId: user.id,
            referenceDataId: referenceData.id
        }),
        await (0, _helpers.createPatientCommunication)({
            models,
            patientId: patient.id
        })
    ]);
};

//# sourceMappingURL=generateEachDataType.js.map