"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createImagingRequest", {
    enumerable: true,
    get: function() {
        return createImagingRequest;
    }
});
const _constants = require("@tamanu/constants");
const _utilities = require("@tamanu/database/demoData/utilities");
const _fake = require("../../fake");
const createImagingRequest = async ({ models, userId, encounterId, locationGroupId, isResulted = _fake.chance.bool() })=>{
    const { ImagingRequest, ImagingResult } = models;
    const imagingRequest = await ImagingRequest.create((0, _fake.fake)(ImagingRequest, {
        requestedById: userId || await (0, _utilities.randomRecordId)(models, 'User'),
        encounterId: encounterId || await (0, _utilities.randomRecordId)(models, 'Encounter'),
        locationGroupId: locationGroupId || await (0, _utilities.randomRecordId)(models, 'LocationGroup'),
        status: _fake.chance.pickone(Object.values(_constants.IMAGING_REQUEST_STATUS_TYPES)),
        priority: 'routine',
        requestedDate: '2022-03-04 15:30:00',
        imagingType: _fake.chance.pickone(Object.values(_constants.IMAGING_TYPES))
    }));
    if (isResulted) {
        await ImagingResult.create((0, _fake.fake)(ImagingResult, {
            imagingRequestId: imagingRequest.id,
            completedById: userId || await (0, _utilities.randomRecordId)(models, 'User'),
            description: 'This is a test result',
            completedAt: '2022-03-04 15:30:00'
        }));
    }
};

//# sourceMappingURL=imagingRequest.js.map