"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createPatient: function() {
        return createPatient;
    },
    createPatientCommunication: function() {
        return createPatientCommunication;
    }
});
const _lodash = require("lodash");
const _utilities = require("@tamanu/database/demoData/utilities");
const _fake = require("../../fake");
const createPatient = async ({ models, facilityId, userId, isBirth = _fake.chance.bool(), isPad = _fake.chance.bool(), isDead = _fake.chance.bool(), allergyCount = _fake.chance.integer({
    min: 0,
    max: 5
}) })=>{
    const { Patient, PatientBirthData, PatientAllergy, PatientAdditionalData, PatientDeathData } = models;
    const patient = await Patient.create((0, _fake.fake)(Patient));
    if (isBirth) {
        await PatientBirthData.create((0, _fake.fake)(PatientBirthData, {
            patientId: patient.id,
            facilityId: facilityId || await (0, _utilities.randomRecordId)(models, 'Facility')
        }));
    }
    if (isPad) {
        await PatientAdditionalData.create((0, _fake.fake)(PatientAdditionalData, {
            patientId: patient.id
        }));
    }
    if (isDead) {
        await PatientDeathData.create((0, _fake.fake)(PatientDeathData, {
            patientId: patient.id,
            clinicianId: userId || await (0, _utilities.randomRecordId)(models, 'User')
        }));
    }
    (0, _lodash.times)(allergyCount, async ()=>{
        await PatientAllergy.create((0, _fake.fake)(PatientAllergy, {
            patientId: patient.id
        }));
    });
    return {
        patient
    };
};
const createPatientCommunication = async ({ models: { PatientCommunication }, patientId })=>{
    await PatientCommunication.create((0, _fake.fake)(PatientCommunication, {
        patientId
    }));
};

//# sourceMappingURL=patient.js.map