"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirReference", {
    enumerable: true,
    get: function() {
        return FhirReference;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _lodash = require("lodash");
const _baseType = require("./baseType");
const _identifier = require("./identifier");
const _logging = require("../logging");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const UPSTREAM_REF_TYPE_PREFIX = 'upstream://';
let FhirReference = class FhirReference extends _baseType.FhirBaseType {
    static SCHEMA() {
        return _yup.object({
            // on ancestor: Element
            id: _yup.string().nullable().default(null),
            reference: _yup.string().nullable().default(null),
            // In spec's schema, this is of type "uri", but it is later
            // mentioned that it can be `"Patient"` as a shorthand, so
            // it can't be the `url()` type in yup.
            type: _yup.string().nullable().default(null),
            identifier: _identifier.FhirIdentifier.asYup().nullable().default(null),
            display: _yup.string().nullable().default(null)
        }).noUnknown();
    }
    static unresolvedReferenceType(resourceModel) {
        return `${UPSTREAM_REF_TYPE_PREFIX}${(0, _lodash.snakeCase)((0, _lodash.lowerCase)(resourceModel.fhirName))}`;
    }
    static async to(resourceModel, upstreamId, fields) {
        if (!upstreamId) {
            _logging.log.warn(`Unable to resolve reference to ${resourceModel.fhirName} with no upstreamId`);
        }
        const resource = upstreamId ? await resourceModel.findOne({
            where: {
                upstreamId
            }
        }) : null;
        if (!resource || !resource.resolved) {
            return this.unresolved(resourceModel, upstreamId, fields);
        }
        return this.resolved(resourceModel, resource.id, fields);
    }
    static resolved(resourceModel, id, fields) {
        return new this({
            type: resourceModel.fhirName,
            reference: `${resourceModel.fhirName}/${id}`,
            ...fields
        });
    }
    static unresolved(resourceModel, upstreamId, fields) {
        return new this({
            type: this.unresolvedReferenceType(resourceModel),
            reference: upstreamId,
            ...fields
        });
    }
    static fake(model, { fieldName }, id) {
        return new this({
            type: model,
            display: `${fieldName}.${id}`
        });
    }
    fhirTypeAndId() {
        const TYPE_ID_URL_REGEX = /\/?(?<type>\w+)\/(?<id>[0-9a-f-]+)$/i;
        const { reference } = this;
        if (!reference) return null;
        const match = TYPE_ID_URL_REGEX.exec(reference);
        if (match) {
            return {
                type: match.groups.type,
                id: match.groups.id
            };
        }
        return null;
    }
    isResolved() {
        return !!this.reference && !this.type.startsWith(UPSTREAM_REF_TYPE_PREFIX);
    }
};

//# sourceMappingURL=reference.js.map