"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "TaskSetExporter", {
    enumerable: true,
    get: function() {
        return TaskSetExporter;
    }
});
const _constants = require("@tamanu/constants");
const _DefaultDataExporter = require("./DefaultDataExporter");
const _sequelize = require("sequelize");
let TaskSetExporter = class TaskSetExporter extends _DefaultDataExporter.DefaultDataExporter {
    async getData() {
        const taskSets = await this.models.ReferenceData.findAll({
            where: {
                type: _constants.REFERENCE_TYPES.TASK_SET
            }
        });
        const tasks = await this.models.ReferenceDataRelation.findAll({
            attributes: [
                'referenceDataId',
                'referenceDataParentId'
            ],
            where: {
                referenceDataParentId: {
                    [_sequelize.Op.in]: taskSets.map(({ id })=>id)
                }
            }
        });
        return taskSets.map((taskSet)=>({
                ...taskSet.dataValues,
                tasks: tasks.filter(({ referenceDataParentId })=>referenceDataParentId === taskSet.id).map(({ referenceDataId })=>referenceDataId).join(',')
            }));
    }
};

//# sourceMappingURL=TaskSetExporter.js.map