//! Keys for use in the LocalSystemFact table
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    FACT_CENTRAL_HOST: function() {
        return FACT_CENTRAL_HOST;
    },
    FACT_CURRENT_SYNC_TICK: function() {
        return FACT_CURRENT_SYNC_TICK;
    },
    FACT_DEVICE_ID: function() {
        return FACT_DEVICE_ID;
    },
    FACT_DEVICE_KEY: function() {
        return FACT_DEVICE_KEY;
    },
    FACT_FACILITY_IDS: function() {
        return FACT_FACILITY_IDS;
    },
    FACT_LAST_SUCCESSFUL_SYNC_PULL: function() {
        return FACT_LAST_SUCCESSFUL_SYNC_PULL;
    },
    FACT_LAST_SUCCESSFUL_SYNC_PUSH: function() {
        return FACT_LAST_SUCCESSFUL_SYNC_PUSH;
    },
    FACT_LOOKUP_UP_TO_TICK: function() {
        return FACT_LOOKUP_UP_TO_TICK;
    },
    FACT_META_SERVER_ID: function() {
        return FACT_META_SERVER_ID;
    },
    FACT_MV_UPCOMING_VACCINATIONS: function() {
        return FACT_MV_UPCOMING_VACCINATIONS;
    },
    FACT_SYNC_TRIGGER_CONTROL: function() {
        return FACT_SYNC_TRIGGER_CONTROL;
    }
});
const _materializedView = require("./materializedView.js");
const FACT_CURRENT_SYNC_TICK = 'currentSyncTick';
const FACT_LAST_SUCCESSFUL_SYNC_PULL = 'lastSuccessfulSyncPull';
const FACT_LAST_SUCCESSFUL_SYNC_PUSH = 'lastSuccessfulSyncPush';
const FACT_LOOKUP_UP_TO_TICK = 'lastSuccessfulLookupTableUpdate';
const FACT_SYNC_TRIGGER_CONTROL = 'syncTrigger';
const FACT_CENTRAL_HOST = 'syncHost';
const FACT_DEVICE_ID = 'deviceId';
const FACT_DEVICE_KEY = 'deviceKey';
const FACT_FACILITY_IDS = 'facilityIds';
const FACT_META_SERVER_ID = 'metaServerId';
const FACT_MV_UPCOMING_VACCINATIONS = `${_materializedView.MATERIALIZED_VIEW_LAST_REFRESHED_AT_KEY_NAMESPACE}:${_materializedView.MATERIALIZED_VIEWS.UPCOMING_VACCINATIONS}`;

//# sourceMappingURL=facts.js.map