"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createProgramRegistry", {
    enumerable: true,
    get: function() {
        return createProgramRegistry;
    }
});
const _lodash = require("lodash");
const _fake = require("../../fake");
const createProgramRegistry = async ({ models, userId, patientId, programRegistryId, conditionCount = _fake.chance.integer({
    min: 1,
    max: 5
}) })=>{
    const { PatientProgramRegistration, PatientProgramRegistrationCondition } = models;
    await PatientProgramRegistration.create((0, _fake.fake)(PatientProgramRegistration, {
        clinicianId: userId,
        patientId,
        programRegistryId
    }));
    (0, _lodash.times)(conditionCount, async ()=>{
        await PatientProgramRegistrationCondition.create((0, _fake.fake)(PatientProgramRegistrationCondition, {
            patientId,
            programRegistryId
        }));
    });
};

//# sourceMappingURL=programRegistry.js.map