"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    LOCATIONS: function() {
        return LOCATIONS;
    },
    LOCATIONS_GROUPS: function() {
        return LOCATIONS_GROUPS;
    },
    seedLocationGroups: function() {
        return seedLocationGroups;
    },
    seedLocations: function() {
        return seedLocations;
    }
});
const _utilities = require("./utilities");
const LOCATIONS = (0, _utilities.splitIds)(`
  Bed 1
  Bed 2
  Bed 3
  Diabetes Clinic
  Resuscitation
  Short-Stay
  Acute Area
  Waiting Area
`);
const seedLocations = async (models)=>{
    const facilityId = await (0, _utilities.randomRecordId)(models, 'Facility');
    const locations = LOCATIONS.map((d)=>({
            ...d,
            code: d.name,
            facilityId,
            maxOccupancy: 1
        }));
    return models.Location.bulkCreate(locations);
};
const LOCATIONS_GROUPS = (0, _utilities.splitIds)(`
  Ward 1
  Ward 2
  Ward 3
  Diabetes Clinic
  Resuscitation
  Short-Stay
  Acute Area
  Waiting Area
`);
const seedLocationGroups = async (models)=>{
    const facilityId = await (0, _utilities.randomRecordId)(models, 'Facility');
    const locationGroups = LOCATIONS_GROUPS.map((d)=>({
            ...d,
            code: d.name,
            facilityId
        }));
    return models.LocationGroup.bulkCreate(locationGroups);
};

//# sourceMappingURL=locations.js.map