import { CompoundCondition as Compound, FieldCondition as Field, DocumentCondition as Document, Condition } from '@ucast/core';
import { JsInterpreter as Interpret } from './types';
import { AnyObject } from './utils';
export declare const or: Interpret<Compound>;
export declare const nor: typeof or;
export declare const and: Interpret<Compound>;
export declare const not: Interpret<Compound>;
export declare const eq: Interpret<Field>;
export declare const ne: typeof eq;
export declare const lte: Interpret<Field<string | number | Date>, string | number | Date | Record<string | number | symbol, unknown>>;
export declare const lt: Interpret<Field<string | number | Date>, string | number | Date | Record<string | number | symbol, unknown>>;
export declare const gt: Interpret<Field<string | number | Date>, string | number | Date | Record<string | number | symbol, unknown>>;
export declare const gte: Interpret<Field<string | number | Date>, string | number | Date | Record<string | number | symbol, unknown>>;
export declare const exists: Interpret<Field<boolean>>;
export declare const mod: Interpret<Field<[number, number]>, number | Record<string | number | symbol, unknown>>;
export declare const size: Interpret<Field<number>, AnyObject | unknown[]>;
export declare const regex: Interpret<Field<RegExp>, string | Record<string | number | symbol, unknown>>;
export declare const within: Interpret<Field<unknown[]>, unknown>;
export declare const nin: typeof within;
export declare const all: Interpret<Field<unknown[]>>;
export declare const elemMatch: Interpret<Field<Condition>>;
declare type WhereFunction = (this: AnyObject) => boolean;
export declare const where: Interpret<Document<WhereFunction>, AnyObject>;
export {};
