"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    closeDatabase: function() {
        return closeDatabase;
    },
    initDatabase: function() {
        return initDatabase;
    },
    initReporting: function() {
        return initReporting;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _database = require("@tamanu/database/services/database");
const _generateId = require("@tamanu/utils/generateId");
const _logging = require("@tamanu/shared/services/logging");
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const getOrCreateConnection = async (configOverrides, key = 'main')=>{
    const testMode = process.env.NODE_ENV === 'test';
    return await (0, _database.openDatabase)(key, {
        ..._config.default.db,
        ...configOverrides,
        testMode
    });
};
async function initDatabase() {
    const testMode = process.env.NODE_ENV === 'test';
    return getOrCreateConnection({
        primaryKeyDefault: testMode ? _generateId.fakeUUID : undefined
    });
}
async function initReportStore(schemaName, credentials) {
    const { username, password, pool } = credentials;
    const overrides = {
        alwaysCreateConnection: false,
        migrateOnStartup: false,
        pool,
        username,
        password
    };
    if (!Object.values(_constants.REPORT_DB_SCHEMAS).includes(schemaName)) {
        _logging.log.warn(`Unknown reporting schema ${schemaName}, skipping...`);
        return null;
    }
    if (!username || !password) {
        _logging.log.warn(`No credentials provided for ${schemaName} reporting schema, skipping...`);
        return null;
    }
    try {
        const connection = getOrCreateConnection(overrides, `reporting-${schemaName}`);
        return connection;
    } catch (e) {
        _logging.log.warn(`It was not possible to establish a connection with the report schema ${schemaName}. Please check the credentials on config file`);
        return null;
    }
}
async function initReporting() {
    const { connections } = _config.default.db.reportSchemas;
    return Object.entries(connections).reduce(async (acc, [schemaName, { username, password }])=>{
        const instance = await initReportStore(schemaName, {
            username,
            password
        });
        if (!instance) return acc;
        return {
            ...await acc,
            [schemaName]: instance
        };
    }, {});
}
async function closeDatabase() {
    return (0, _database.closeAllDatabases)();
}

//# sourceMappingURL=initDatabase.js.map