"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "referral", {
    enumerable: true,
    get: function() {
        return referral;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _crudHelpers = require("@tamanu/shared/utils/crudHelpers");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const referral = _express.default.Router();
referral.get('/:id', (0, _crudHelpers.simpleGet)('Referral'));
referral.put('/:id', (0, _crudHelpers.simplePut)('Referral'));
referral.post('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models, body: { facilityId, ...body }, db, settings } = req;
    req.checkPermission('create', 'Referral');
    const getDefaultId = async (type)=>models.SurveyResponseAnswer.getDefaultId(type, settings[facilityId]);
    const updatedBody = {
        locationId: body.locationId || await getDefaultId('location'),
        departmentId: body.departmentId || await getDefaultId('department'),
        userId: req.user.id,
        facilityId,
        ...body
    };
    const referralRecord = await db.transaction(async ()=>{
        const surveyResponseRecord = await models.SurveyResponse.createWithAnswers(updatedBody);
        return models.Referral.create({
            initiatingEncounterId: surveyResponseRecord.encounterId,
            surveyResponseId: surveyResponseRecord.id,
            ...req.body
        });
    });
    res.send(referralRecord);
}));
const referralRelations = (0, _crudHelpers.permissionCheckingRouter)('read', 'Referral');
referral.use(referralRelations);

//# sourceMappingURL=referral.js.map