"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "upcomingVaccinations", {
    enumerable: true,
    get: function() {
        return upcomingVaccinations;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _sequelize = require("sequelize");
const _vaccines = require("@tamanu/constants/vaccines");
const _query = require("../../utils/query");
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const upcomingVaccinations = _express.default.Router();
const createUpcomingVaccinationFilters = (filterParams)=>{
    const filters = [
        (0, _query.makeFilter)(filterParams.displayId, `(UPPER(p.display_id) LIKE UPPER(:displayId))`, ({ displayId })=>({
                displayId: `%${displayId}%`
            })),
        (0, _query.makeFilter)(filterParams.firstName, `UPPER(p.first_name) LIKE UPPER(:firstName)`, ({ firstName })=>({
                firstName: `%${firstName}%`
            })),
        (0, _query.makeFilter)(filterParams.lastName, `UPPER(p.last_name) LIKE UPPER(:lastName)`, ({ lastName })=>({
                lastName: `%${lastName}%`
            })),
        (0, _query.makeFilter)(filterParams.sex, `p.sex = :sex`),
        (0, _query.makeFilter)(filterParams.villageId, `p.village_id = :villageId`),
        (0, _query.makeFilter)(filterParams.status, `uv.status = :status`)
    ];
    return filters.filter((f)=>f);
};
upcomingVaccinations.get('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('read', 'PatientVaccine');
    const sortKeys = {
        displayId: 'display_id',
        fullName: 'last_name',
        dateOfBirth: 'date_of_birth',
        sex: 'sex',
        villageName: 'village.name',
        vaccineDisplayName: 'sv.label',
        schedule: 'sv.dose_label',
        dueDate: 'due_date'
    };
    const { orderBy = 'dueDate', order = 'ASC', rowsPerPage = 10, page = 0, ...filterParams } = req.query;
    let sortKey = sortKeys[orderBy];
    const sortDirection = order.toLowerCase() === 'asc' ? 'ASC' : 'DESC';
    const filters = createUpcomingVaccinationFilters(filterParams);
    const filterClauses = filters.map((f)=>f.sql).join(' AND ');
    const whereClauses = `uv.status <> 'MISSED' ${filterClauses ? `AND ${filterClauses}` : ''}`;
    const filterReplacements = filters.filter((f)=>f.transform).reduce((current, { transform })=>({
            ...current,
            ...transform(current)
        }), filterParams);
    // Use the materialized version of the view if the regular refresh task is enabled, otherwise use the regular live view (not recommended for performance reasons)
    const { enabled } = _config.default.schedules.refreshMaterializedView.upcomingVaccinations;
    const tableName = enabled === false ? 'upcoming_vaccinations' : 'materialized_upcoming_vaccinations';
    const withRowNumber = `
      WITH upcoming_vaccinations_with_row_number AS (
        SELECT *,
        ROW_NUMBER() OVER(PARTITION BY patient_id ORDER BY due_date ASC) AS row_number
        FROM ${tableName} uv
        WHERE uv.status <> '${_vaccines.VACCINE_STATUS.MISSED}'
      )
    `;
    const fromUpcomingVaccinations = `
      FROM upcoming_vaccinations_with_row_number uv
      JOIN scheduled_vaccines sv ON sv.id = uv.scheduled_vaccine_id
      JOIN patients p ON p.id = uv.patient_id
      LEFT JOIN reference_data village ON village.id = p.village_id
      WHERE ${whereClauses}
      AND row_number = 1
    `;
    const results = await req.db.query(`
      ${withRowNumber}
      SELECT
      p.id id,
      p.display_id "displayId",
      p.first_name "firstName",
      p.last_name "lastName",
      p.date_of_birth "dateOfBirth",
      p.sex,
      sv.id "scheduledVaccineId",
      sv.category,
      sv.label "vaccineName",
      sv.dose_label "scheduleName",
      sv.vaccine_id "vaccineId",
      uv.due_date "dueDate",
      uv.status,
      village.name "villageName",
      village.id "villageId"
      ${fromUpcomingVaccinations}
      ORDER BY ${sortKey} ${sortDirection}, sv.label
      LIMIT :limit
      OFFSET :offset;`, {
        replacements: {
            limit: rowsPerPage,
            offset: page * rowsPerPage,
            ...filterReplacements
        },
        type: _sequelize.QueryTypes.SELECT
    });
    const countResult = await req.db.query(`
      ${withRowNumber}
      SELECT COUNT(1) AS count ${fromUpcomingVaccinations};`, {
        replacements: filterReplacements,
        type: _sequelize.QueryTypes.SELECT
    });
    return res.send({
        data: results,
        count: parseInt(countResult[0].count, 10)
    });
}));
upcomingVaccinations.get('/updateStats', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models } = req;
    const { LocalSystemFact } = models;
    req.checkPermission('read', 'PatientVaccine');
    const { schedule, enabled } = _config.default.schedules.refreshMaterializedView.upcomingVaccinations;
    if (enabled === false) {
        // If the task is disabled, stats are not needed
        return res.send({});
    }
    const lastRefreshed = await LocalSystemFact.get(`${_constants.MATERIALIZED_VIEW_LAST_REFRESHED_AT_KEY_NAMESPACE}:${_constants.MATERIALIZED_VIEWS.UPCOMING_VACCINATIONS}`);
    return res.send({
        lastRefreshed,
        schedule
    });
}));

//# sourceMappingURL=upcomingVaccinations.js.map