import { times } from 'lodash';
import { randomRecordId } from '@tamanu/database/demoData/utilities';
import { fake, chance } from '../../fake/index.js';
export const createPatient = async ({ models, limit, facilityId, userId, isBirth = chance.bool(), isDead = chance.bool(), allergyCount = chance.integer({
    min: 0,
    max: 5
}) })=>{
    const { Patient, PatientBirthData, PatientAllergy, PatientAdditionalData, PatientDeathData } = models;
    const patient = await Patient.create(fake(Patient));
    await PatientAdditionalData.create(fake(PatientAdditionalData, {
        patientId: patient.id
    }));
    if (isBirth) {
        await PatientBirthData.create(fake(PatientBirthData, {
            patientId: patient.id,
            facilityId: facilityId || await randomRecordId(models, 'Facility')
        }));
    }
    if (isDead) {
        await PatientDeathData.create(fake(PatientDeathData, {
            patientId: patient.id,
            clinicianId: userId || await randomRecordId(models, 'User')
        }));
    }
    await Promise.all(times(allergyCount, ()=>limit(async ()=>{
            await PatientAllergy.create(fake(PatientAllergy, {
                patientId: patient.id
            }));
        })));
    return {
        patient
    };
};
export const createPatientCommunication = async ({ models: { PatientCommunication }, patientId })=>{
    await PatientCommunication.create(fake(PatientCommunication, {
        patientId
    }));
};

//# sourceMappingURL=patient.js.map