import { Sequelize } from 'sequelize';
import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
export declare class ReportDefinitionVersion extends Model {
    id: string;
    versionNumber: number;
    notes?: string;
    status: string;
    query: string;
    queryOptions: Record<string, any>;
    reportDefinitionId?: string;
    userId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    getQueryOptions(): any;
    getParameters(): any;
    dataGenerator({ sequelize, reportSchemaStores, facilityId, }: {
        sequelize: Sequelize;
        reportSchemaStores: any;
        facilityId: string;
    }, parameters: any): Promise<any[][]>;
    forResponse(includeRelationIds?: boolean): any;
    static buildSyncFilter(): null;
    static buildSyncLookupQueryDetails(): null;
}
//# sourceMappingURL=ReportDefinitionVersion.d.ts.map