"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "MerlinProvider", {
    enumerable: true,
    get: function() {
        return MerlinProvider;
    }
});
const _nodefetch = /*#__PURE__*/ _interop_require_default(require("node-fetch"));
const _Provider = require("./Provider");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let MerlinProvider = class MerlinProvider extends _Provider.Provider {
    async getUrlForResult(result) {
        const { Encounter, Patient } = this.models;
        const { externalCode } = result;
        if (!externalCode) return null;
        const request = await result.getRequest({
            include: [
                {
                    model: Encounter,
                    as: 'encounter',
                    include: [
                        {
                            model: Patient,
                            as: 'patient'
                        }
                    ]
                }
            ]
        });
        const { patient } = request.encounter;
        const { urlgen, auth: { username, password }, patientId: { type, field } } = this.config;
        const url = new URL(urlgen);
        url.username = username;
        url.password = password;
        url.searchParams.set('accession', externalCode);
        url.searchParams.set('patIdType', type);
        url.searchParams.set('patId', patient[field]);
        const res = await (0, _nodefetch.default)(url);
        return res.text();
    }
};

//# sourceMappingURL=MerlinProvider.js.map