"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientBirthData", {
    enumerable: true,
    get: function() {
        return PatientBirthData;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_wildcard(require("sequelize"));
const _constants = require("@tamanu/constants");
const _errors = require("@tamanu/shared/errors");
const _Model = require("./Model");
const _buildPatientSyncFilterViaPatientId = require("../sync/buildPatientSyncFilterViaPatientId");
const _buildPatientLinkedLookupFilter = require("../sync/buildPatientLinkedLookupFilter");
const _model = require("../types/model");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
let PatientBirthData = class PatientBirthData extends _Model.Model {
    static initModel(options) {
        super.init({
            id: {
                // patient birth data records use a patient_id as the primary key, acting as a
                // db-level enforcement of one per patient, and simplifying sync
                type: `TEXT GENERATED ALWAYS AS ("patient_id")`,
                set () {
                // any sets of the convenience generated "id" field can be ignored, so do nothing here
                }
            },
            patientId: {
                type: _sequelize.DataTypes.STRING,
                primaryKey: true,
                references: {
                    model: 'patients',
                    key: 'id'
                }
            },
            birthWeight: {
                type: _sequelize.default.DECIMAL
            },
            birthLength: {
                type: _sequelize.default.DECIMAL
            },
            birthDeliveryType: {
                type: _sequelize.default.STRING
            },
            attendantAtBirth: {
                type: _sequelize.default.STRING
            },
            nameOfAttendantAtBirth: {
                type: _sequelize.default.STRING
            },
            gestationalAgeEstimate: {
                type: _sequelize.default.FLOAT
            },
            apgarScoreOneMinute: {
                type: _sequelize.default.INTEGER
            },
            apgarScoreFiveMinutes: {
                type: _sequelize.default.INTEGER
            },
            apgarScoreTenMinutes: {
                type: _sequelize.default.INTEGER
            },
            timeOfBirth: (0, _model.dateTimeType)('timeOfBirth'),
            birthType: {
                type: _sequelize.default.STRING
            },
            registeredBirthPlace: {
                type: _sequelize.default.STRING
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            tableName: 'patient_birth_data',
            validate: {
                mustHavePatient () {
                    if (this.deletedAt) {
                        return;
                    }
                    if (!this.patientId) {
                        throw new _errors.InvalidOperationError('Patient birth data must have a patient.');
                    }
                }
            }
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId'
        });
        this.belongsTo(models.Facility, {
            foreignKey: 'birthFacilityId',
            as: 'facility'
        });
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildPatientLinkedLookupFilter.buildPatientLinkedLookupFilter)(this);
    }
};
_define_property(PatientBirthData, "nonMetadataColumns", [
    'patientId',
    'birthWeight',
    'birthLength',
    'birthDeliveryType',
    'gestationalAgeEstimate',
    'apgarScoreOneMinute',
    'apgarScoreFiveMinutes',
    'apgarScoreTenMinutes',
    'timeOfBirth',
    'birthType',
    'attendantAtBirth',
    'nameOfAttendantAtBirth',
    'birthFacilityId',
    'registeredBirthPlace'
]);
_define_property(PatientBirthData, "buildPatientSyncFilter", _buildPatientSyncFilterViaPatientId.buildPatientSyncFilterViaPatientId);

//# sourceMappingURL=PatientBirthData.js.map