"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "UserFacility", {
    enumerable: true,
    get: function() {
        return UserFacility;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let UserFacility = class UserFacility extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
            uniqueKeys: {
                user_location_unique: {
                    fields: [
                        'user_id',
                        'facility_id'
                    ]
                }
            }
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Facility, {
            foreignKey: 'facilityId',
            as: 'facility'
        });
        this.belongsTo(models.User, {
            foreignKey: 'userId',
            as: 'user'
        });
    }
    static async create(values, options) {
        const { facilityId } = values;
        const existingFacility = await this.sequelize.models.Facility.findOne({
            where: {
                id: facilityId
            }
        });
        if (!existingFacility) {
            throw new _sequelize.ValidationError(`Invalid facilityId: ${facilityId}`, []);
        }
        return super.create(values, options);
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=UserFacility.js.map