<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function expm1

Calculate the value of subtracting 1 from the exponential value.
For matrices, the function is evaluated element wise.


## Syntax

```js
math.expm1(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Complex &#124; Array &#124; Matrix | A number or matrix to apply expm1

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Complex &#124; Array &#124; Matrix | Exponent of `x`


## Examples

```js
math.expm1(2)                      // returns number 6.38905609893065
math.pow(math.e, 2) - 1            // returns number 6.3890560989306495
math.log(math.expm1(2) + 1)        // returns number 2

math.expm1([1, 2, 3])
// returns Array [
//   1.718281828459045,
//   6.3890560989306495,
//   19.085536923187668
// ]
```


## See also

[exp](exp.md),
[log](log.md),
[pow](pow.md)
