"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const syncColumns = {
    marked_for_push: {
        type: _sequelize.default.BOOLEAN,
        allowNull: false,
        defaultValue: true
    },
    is_pushing: {
        type: _sequelize.default.BOOLEAN,
        allowNull: false,
        defaultValue: false
    },
    pushed_at: {
        type: _sequelize.default.DATE,
        allowNull: true
    },
    pulled_at: {
        type: _sequelize.default.DATE,
        allowNull: true
    }
};
async function up(query) {
    await query.createTable('location_groups', {
        id: {
            type: _sequelize.default.STRING,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.default.UUIDV4
        },
        created_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.NOW,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.NOW,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.default.DATE,
            allowNull: true
        },
        visibility_status: {
            type: _sequelize.default.TEXT,
            defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
        },
        name: {
            type: _sequelize.default.STRING,
            allowNull: false
        },
        code: {
            type: _sequelize.default.STRING,
            allowNull: false
        },
        facility_id: {
            type: _sequelize.default.STRING,
            allowNull: false,
            references: {
                model: 'facilities',
                key: 'id'
            }
        },
        ...syncColumns
    });
    await query.addColumn('locations', 'location_group_id', {
        type: _sequelize.default.STRING,
        allowNull: true,
        default: null,
        references: {
            model: 'location_groups',
            key: 'id'
        }
    });
}
async function down(query) {
    await query.removeColumn('locations', 'location_group_id');
    await query.dropTable('location_groups');
}

//# sourceMappingURL=121_addLocationGroupsTable.js.map