"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "UserDesignation", {
    enumerable: true,
    get: function() {
        return UserDesignation;
    }
});
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let UserDesignation = class UserDesignation extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'userId',
            as: 'user'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'designationId',
            as: 'referenceData'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=UserDesignation.js.map