"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirImmunization", {
    enumerable: true,
    get: function() {
        return FhirImmunization;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Resource = require("./Resource");
const _Immunization = require("../../utils/fhir/Immunization");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let FhirImmunization = class FhirImmunization extends _Resource.FhirResource {
    static initModel(options, models) {
        super.initResource({
            status: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            vaccineCode: {
                type: _sequelize.DataTypes.JSONB,
                allowNull: false
            },
            patient: {
                type: _sequelize.DataTypes.JSONB,
                allowNull: false
            },
            encounter: {
                type: _sequelize.DataTypes.JSONB,
                allowNull: true
            },
            occurrenceDateTime: _sequelize.DataTypes.TEXT,
            lotNumber: _sequelize.DataTypes.TEXT,
            site: _sequelize.DataTypes.JSONB,
            performer: _sequelize.DataTypes.JSONB,
            protocolApplied: _sequelize.DataTypes.JSONB
        }, options);
        this.UpstreamModels = [
            models.AdministeredVaccine
        ];
        this.upstreams = [
            models.AdministeredVaccine,
            models.Encounter,
            models.Patient,
            models.ReferenceData,
            models.ScheduledVaccine,
            models.User
        ];
    }
    async updateMaterialisation() {
        const upstream = await this.getUpstream((0, _Immunization.getQueryOptions)(this.sequelize.models));
        const values = await (0, _Immunization.getValues)(upstream, this.sequelize.models);
        this.set(values);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id) {
        const { AdministeredVaccine } = this.sequelize.models;
        if (upstreamTable === AdministeredVaccine.tableName) {
            return (0, _Immunization.fromAdministeredVaccines)(this.sequelize.models, table, id);
        }
        return null;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ..._Immunization.searchParameters
        };
    }
};
_define_property(FhirImmunization, "CAN_DO", new Set([
    _constants.FHIR_INTERACTIONS.INSTANCE.READ,
    _constants.FHIR_INTERACTIONS.TYPE.SEARCH,
    _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE
]));

//# sourceMappingURL=FhirImmunization.js.map