"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    registerSyncLookupUpdateListener: function() {
        return registerSyncLookupUpdateListener;
    },
    updateChildRecordsForSyncLookup: function() {
        return updateChildRecordsForSyncLookup;
    }
});
const _lodash = require("lodash");
const _constants = require("@tamanu/constants");
const _database = require("@tamanu/database");
async function updateChildRecordsForSyncLookup(model, instanceId) {
    const dependantAssociations = (0, _database.getDependentAssociations)(model);
    for (const association of dependantAssociations){
        const { target, foreignKey } = association;
        // We need to go via a raw query as Model.update({}) performs validation on the
        // whole record, so we'll be rejected for failing to include required fields -
        // even though we only want to update updated_at_sync_tick!
        const [updatedRows] = await model.sequelize.query(`
      UPDATE ${target.tableName}
      SET updated_at_sync_tick = 1
      WHERE ${(0, _lodash.snakeCase)(foreignKey)} = :instanceId
      RETURNING id;
    `, {
            replacements: {
                instanceId
            }
        });
        // If there are any child records, also recursively update them
        // so that they are also updated in the sync_lookup table
        // eg: if survey_response is updated, we must also updated survey_response_answers
        for (const updatedRow of updatedRows){
            await updateChildRecordsForSyncLookup(target, updatedRow.id);
        }
    }
}
const registerSyncLookupUpdateListener = async (models, dbNotifier)=>{
    const onTableChanged = dbNotifier.listeners[_constants.NOTIFY_CHANNELS.TABLE_CHANGED];
    onTableChanged(async (payload)=>{
        if (payload.event === 'UPDATE' && payload.changedColumns?.includes('patient_id')) {
            const model = Object.values(models).find((model)=>model.tableName === payload.table);
            await updateChildRecordsForSyncLookup(model, payload.newId);
        }
    });
};

//# sourceMappingURL=registerSyncLookupUpdateListener.js.map