/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.renameColumn('tasks', 'not_completed_note', 'not_completed_reason_id');
    await query.sequelize.query(`UPDATE tasks SET not_completed_reason_id = NULL`);
    await query.changeColumn('tasks', 'not_completed_reason_id', {
        type: _sequelize.DataTypes.TEXT,
        allowNull: true,
        references: {
            model: 'reference_data',
            key: 'id'
        }
    });
}
async function down(query) {
    await query.changeColumn('tasks', 'not_completed_reason_id', {
        type: _sequelize.DataTypes.TEXT,
        allowNull: true,
        references: undefined
    });
    await query.renameColumn('tasks', 'not_completed_reason_id', 'not_completed_note');
}

//# sourceMappingURL=1724662141918-addNotCompleteReasonIdToTaskTable.js.map