function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { getCurrentDateTimeString } from '@tamanu/utils/dateTime';
import { Model } from './Model';
import { buildPatientSyncFilterViaPatientId } from '../sync/buildPatientSyncFilterViaPatientId';
import { buildPatientLinkedLookupFilter } from '../sync/buildPatientLinkedLookupFilter';
import { dateTimeType } from '../types/model';
export class PatientAllergy extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            note: DataTypes.STRING,
            recordedDate: dateTimeType('recordedDate', {
                defaultValue: getCurrentDateTimeString,
                allowNull: false
            })
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId'
        });
        this.belongsTo(models.User, {
            foreignKey: 'practitionerId'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'allergyId',
            as: 'allergy'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'reactionId',
            as: 'reaction'
        });
    }
    static getListReferenceAssociations() {
        return [
            'allergy',
            'reaction'
        ];
    }
    static buildSyncLookupQueryDetails() {
        return buildPatientLinkedLookupFilter(this);
    }
}
_define_property(PatientAllergy, "buildPatientSyncFilter", buildPatientSyncFilterViaPatientId);

//# sourceMappingURL=PatientAllergy.js.map