"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "location", {
    enumerable: true,
    get: function() {
        return location;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _constants = require("@tamanu/constants");
const _crudHelpers = require("@tamanu/shared/utils/crudHelpers");
const _sequelize = require("sequelize");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const location = _express.default.Router();
location.get('/:id', (0, _crudHelpers.simpleGet)('Location'));
location.put('/:id', (0, _crudHelpers.simplePut)('Location'));
location.post('/$', (0, _crudHelpers.simplePost)('Location'));
location.get('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('list', 'Location');
    const { models: { LocationGroup }, query: { bookableOnly = false, locationGroupIds } } = req;
    const { facilityId } = req.query;
    const locations = await req.models.Location.findAll({
        where: {
            facilityId,
            visibilityStatus: _constants.VISIBILITY_STATUSES.CURRENT
        },
        include: [
            {
                required: true,
                model: LocationGroup,
                as: 'locationGroup',
                where: {
                    visibilityStatus: _constants.VISIBILITY_STATUSES.CURRENT,
                    ...bookableOnly ? {
                        isBookable: true
                    } : null,
                    ...locationGroupIds ? {
                        id: {
                            [_sequelize.Op.in]: locationGroupIds
                        }
                    } : null
                }
            }
        ],
        order: [
            [
                'locationGroup',
                'name',
                'ASC'
            ],
            [
                'name',
                'ASC'
            ]
        ]
    });
    res.send(locations);
}));

//# sourceMappingURL=location.js.map