"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirAddress", {
    enumerable: true,
    get: function() {
        return FhirAddress;
    }
});
const _chance = require("chance");
const _lodash = require("lodash");
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _baseType = require("./baseType");
const _period = require("./period");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const USES = [
    'home',
    'work',
    'temp',
    'old',
    'billing'
];
const TYPES = [
    'postal',
    'physical',
    'both'
];
let FhirAddress = class FhirAddress extends _baseType.FhirBaseType {
    static SCHEMA() {
        return _yup.object({
            use: _yup.string().oneOf([
                null,
                ...USES
            ]).nullable().default(null),
            type: _yup.string().oneOf([
                null,
                ...TYPES
            ]).nullable().default(null),
            text: _yup.string().nullable().default(null),
            line: _yup.array().of(_yup.string().nullable()).nullable().default([
                null
            ]),
            city: _yup.string().nullable().default(null),
            district: _yup.string().nullable().default(null),
            state: _yup.string().nullable().default(null),
            postalCode: _yup.string().nullable().default(null),
            country: _yup.string().nullable().default(null),
            period: _period.FhirPeriod.asYup().nullable().default(null)
        }).noUnknown();
    }
    // FIXME: Check this mention of the spec via Yup:
    // > The text element specifies the entire address as it should be displayed e.g. on a postal
    // > label. This may be provided instead of or as well as the specific parts. Applications
    // > updating an address SHALL ensure that when both text and parts are present, no content is
    // > included in the text that isn't found in a part.
    // -- https://www.hl7.org/fhir/datatypes.html#Address
    static fake() {
        const chance = new _chance.Chance();
        return new this({
            use: (0, _lodash.sample)(USES),
            type: (0, _lodash.sample)(TYPES),
            text: chance.address()
        });
    }
};

//# sourceMappingURL=address.js.map