"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    changePassword: function() {
        return changePassword;
    },
    userCommand: function() {
        return userCommand;
    }
});
const _commander = require("commander");
const _util = require("util");
const _read = /*#__PURE__*/ _interop_require_default(require("read"));
const _importable = require("@tamanu/constants/importable");
const _database = require("../database");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const read = (0, _util.promisify)(_read.default);
const readPassword = (prompt)=>read({
        silent: true,
        prompt,
        replace: '*'
    });
const changePassword = async ({ email })=>{
    const store = await (0, _database.initDatabase)({
        testMode: false
    });
    const { User } = store.models;
    // check user exists
    const user = await User.findOne({
        where: {
            email,
            visibilityStatus: _importable.VISIBILITY_STATUSES.CURRENT
        }
    });
    if (!user) {
        throw new Error('Could not find a user with specified email');
    }
    // read password twice and ensure it matches
    const password = await readPassword('New password:');
    const passwordCheck = await readPassword('New password (again):');
    if (password !== passwordCheck) {
        throw new Error('Passwords must match');
    }
    // update and verify the update went through
    const [num] = await User.update({
        password
    }, {
        where: {
            email
        }
    });
    if (num === 0) {
        throw new Error('Found a user, but updated 0 records (another process may have modified the user)');
    }
};
const userCommand = new _commander.Command('user').command('changePassword').requiredOption('-e, --email <email>') // this is an option to allow e.g. --id in future
.action(changePassword);

//# sourceMappingURL=user.js.map