"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ChangeLog", {
    enumerable: true,
    get: function() {
        return ChangeLog;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let ChangeLog = class ChangeLog extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            tableOid: {
                type: _sequelize.DataTypes.INTEGER,
                allowNull: false
            },
            tableSchema: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            tableName: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            loggedAt: {
                type: _sequelize.DataTypes.DATE,
                allowNull: false,
                defaultValue: _sequelize.Sequelize.fn('adjusted_timestamp')
            },
            updatedByUserId: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            recordId: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            recordUpdate: {
                type: _sequelize.DataTypes.BOOLEAN,
                allowNull: false
            },
            recordCreatedAt: {
                type: _sequelize.DataTypes.DATE,
                allowNull: false
            },
            recordUpdatedAt: {
                type: _sequelize.DataTypes.DATE,
                allowNull: false
            },
            recordDeletedAt: {
                type: _sequelize.DataTypes.DATE,
                allowNull: true
            },
            recordSyncTick: {
                type: _sequelize.DataTypes.BIGINT,
                allowNull: false
            },
            recordData: {
                type: _sequelize.DataTypes.JSONB,
                allowNull: false
            }
        }, {
            ...options,
            tableName: 'changes',
            syncDirection: _constants.SYNC_DIRECTIONS.PUSH_TO_CENTRAL,
            schema: 'logs'
        });
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'updatedByUserId',
            as: 'updatedByUser'
        });
    }
};

//# sourceMappingURL=ChangeLog.js.map