import { Model } from './Model';
import { type InitOptions, type ModelProperties, type Models } from '../types/model';
import type { Location } from './Location';
import type { Patient } from './Patient';
import type { Discharge } from './Discharge';
import type { SessionConfig } from '../types/sync';
import type { User } from './User';
export declare class Encounter extends Model {
    id: string;
    encounterType?: string;
    startDate: string;
    endDate?: string;
    reasonForEncounter?: string;
    deviceId?: string;
    plannedLocationStartTime?: string;
    patientId?: string;
    examinerId?: string;
    locationId?: string;
    plannedLocationId?: string;
    departmentId?: string;
    patientBillingTypeId?: string;
    referralSourceId?: string;
    location?: Location;
    patient?: Patient;
    discharge?: Discharge;
    dischargeDraft?: Record<string, any>;
    static initModel({ primaryKey, hackToSkipEncounterValidation, ...options }: InitOptions, models: Models): void;
    static getFullReferenceAssociations(): (string | {
        association: string;
        include: string[];
    })[];
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string, sessionConfig: SessionConfig): string | null;
    static buildSyncLookupQueryDetails(): {
        select: string;
        joins: string;
        where: string;
    };
    static adjustDataPostSyncPush(recordIds: string[]): Promise<void>;
    static create(...args: any): Promise<any>;
    addLocationChangeNote(contentPrefix: string, newLocationId: string, submittedTime: string, user: ModelProperties<User>): Promise<void>;
    addDepartmentChangeNote(toDepartmentId: string, submittedTime: string, user: ModelProperties<User>): Promise<void>;
    addTriageScoreNote(triageRecord: {
        score: any;
        triageTime: string;
    }, user: ModelProperties<User>): Promise<void>;
    addSystemNote(content: string, date: string, user: ModelProperties<User>): Promise<any>;
    getLinkedTriage(): Promise<import("./Triage").Triage | null>;
    onDischarge({ endDate, submittedTime, systemNote, discharge, }: {
        endDate: string;
        submittedTime: string;
        systemNote?: string;
        discharge: ModelProperties<Discharge>;
    }, user: ModelProperties<User>): Promise<void>;
    onEncounterProgression(newEncounterType: Encounter['encounterType'], submittedTime: string, user: ModelProperties<User>): Promise<void>;
    closeTriage(endDate: string): Promise<void>;
    updateClinician(newClinicianId: string, submittedTime: string, user: ModelProperties<User>): Promise<void>;
    update(...args: any): Promise<any>;
}
//# sourceMappingURL=Encounter.d.ts.map