import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
export declare class TaskTemplate extends Model {
    id: string;
    referenceDataId: number;
    frequencyValue?: number;
    frequencyUnit?: string;
    highPriority?: boolean;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildSyncFilter(): null;
    static buildSyncLookupQueryDetails(): null;
    static getFullReferenceAssociations(): (string | {
        model: typeof import("./TaskTemplateDesignation").TaskTemplateDesignation;
        as: string;
        include: {
            model: typeof import("./ReferenceData").ReferenceData;
            as: string;
            attributes: string[];
        }[];
    })[];
}
//# sourceMappingURL=TaskTemplate.d.ts.map