import { FhirResource } from './Resource';
import type { InitOptions, Models } from '../../types/model';
export declare class FhirSpecimen extends FhirResource {
    collection?: Record<string, any>;
    request?: Record<string, any>;
    type?: Record<string, any>;
    static initModel(options: InitOptions, models: Models): void;
    static CAN_DO: Set<string>;
    updateMaterialisation(): Promise<void>;
    static queryToFindUpstreamIdsFromTable(upstreamTable: string, table: string, id: string): Promise<{
        where: {
            id: string;
        };
    } | null>;
    static queryToFilterUpstream(upstreamTable: string): Promise<{
        where: {
            specimenAttached: boolean;
        };
    } | null>;
    static searchParameters(): {
        collector: {
            type: string;
            path: string[][];
            referenceTypes: string[];
        };
    };
}
//# sourceMappingURL=FhirSpecimen.d.ts.map