"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createSyncApp", {
    enumerable: true,
    get: function() {
        return createSyncApp;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _errorHandler = /*#__PURE__*/ _interop_require_default(require("./middleware/errorHandler"));
const _http = require("http");
const _addFacilityMiddleware = require("./addFacilityMiddleware");
const _sync = require("./routes/sync/sync");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function createSyncApp({ sequelize, syncManager, models, deviceId }) {
    const express = (0, _express.default)();
    const server = (0, _http.createServer)(express);
    const { errorMiddleware } = (0, _addFacilityMiddleware.addFacilityMiddleware)(express);
    express.use((req, res, next)=>{
        req.models = models;
        req.db = sequelize;
        req.syncManager = syncManager;
        req.deviceId = deviceId;
        next();
    });
    // index route for debugging connectivity
    express.get('/$', (req, res)=>{
        res.send({
            index: true
        });
    });
    // Only contain sync routes in this app
    express.use('/sync', _sync.sync);
    // Dis-allow all other routes
    express.get('*', (req, res)=>{
        res.status(404).end();
    });
    if (errorMiddleware) {
        express.use(errorMiddleware);
    }
    express.use(_errorHandler.default);
    return {
        express,
        server
    };
}

//# sourceMappingURL=createSyncApp.js.map