"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "SettingsDBReader", {
    enumerable: true,
    get: function() {
        return SettingsDBReader;
    }
});
const _Reader = require("./Reader");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let SettingsDBReader = class SettingsDBReader extends _Reader.Reader {
    async getSettings() {
        const { Setting } = this.models;
        // Get all settings for the selected scope/facility
        const settings = await Setting.get('', this.facilityId, this.scope);
        return settings;
    }
    constructor(models, scope, facilityId){
        super(), _define_property(this, "models", void 0), _define_property(this, "scope", void 0), _define_property(this, "facilityId", void 0);
        this.models = models;
        this.scope = scope;
        this.facilityId = facilityId;
    }
};

//# sourceMappingURL=SettingsDBReader.js.map