import * as yup from 'yup';
export declare const centralSettings: {
    name: string;
    description: string;
    properties: {
        disk: {
            name: string;
            description: string;
            properties: {
                freeSpaceRequired: {
                    name: string;
                    description: string;
                    properties: {
                        gigabytesForUploadingDocuments: {
                            name: string;
                            description: string;
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                        };
                    };
                };
            };
        };
        questionCodeIds: {
            deprecated: boolean;
            description: string;
            properties: {
                passport: {
                    type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                    defaultValue: any;
                };
                nationalityId: {
                    type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                    defaultValue: any;
                };
                email: {
                    type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                    defaultValue: any;
                };
            };
        };
        reportProcess: {
            properties: {
                timeOutDurationSeconds: {
                    description: string;
                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                    defaultValue: number;
                    unit: string;
                };
                runInChildProcess: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                processOptions: {
                    description: string;
                    type: yup.ArraySchema<string[], yup.AnyObject, undefined, "">;
                    defaultValue: any;
                };
                childProcessEnv: {
                    description: string;
                    type: yup.ObjectSchema<{}, yup.AnyObject, {}, "">;
                    defaultValue: any;
                };
                sleepAfterReport: {
                    description: string;
                    properties: {
                        duration: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        ifRunAtLeast: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
            };
        };
    };
};
export declare const centralDefaults: any;
