"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "checkSignerConfig", {
    enumerable: true,
    get: function() {
        return checkSignerConfig;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const CN_SCHEMA_VDS_NC = _yup.string().length(2).uppercase();
const CN_SCHEMA_EU_DCC = _yup.string().min(1);
const SCHEMA = _yup.object().shape({
    enabled: _yup.boolean().default(false),
    keySecret: _yup.string().required().test('is-base64', 'keySecret must be Base64 data', (value)=>Buffer.from(value, 'base64').toString('base64') === value).test('at-least-32-bytes', 'keySecret must be at least 32 bytes of data', (value)=>Buffer.from(value, 'base64').length >= 32),
    commonName: _config.default.integrations.vdsNc.enabled ? CN_SCHEMA_VDS_NC.required() : CN_SCHEMA_EU_DCC.required(),
    provider: _yup.string(),
    sendRequestTo: _yup.string().email().required('CSR emails are the only supported renewal methods at the moment')
}).noUnknown();
function checkSignerConfig() {
    const { signer } = _config.default.integrations;
    if (signer.enabled) SCHEMA.validateSync(signer);
}

//# sourceMappingURL=Config.js.map