"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.addColumn('encounter_history', 'actor_id', {
        type: _sequelize.default.STRING,
        references: {
            model: 'users',
            key: 'id'
        },
        allowNull: true
    });
    await query.addColumn('encounter_history', 'change_type', {
        type: _sequelize.default.STRING,
        allowNull: true
    });
}
async function down(query) {
    await query.removeColumn('encounter_history', 'actor_id');
    await query.removeColumn('encounter_history', 'change_type');
}

//# sourceMappingURL=1693040825684-addExtraEncounterHistoryColumns.js.map