"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "medication", {
    enumerable: true,
    get: function() {
        return medication;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _crudHelpers = require("@tamanu/shared/utils/crudHelpers");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const medication = _express.default.Router();
medication.get('/:id', (0, _crudHelpers.simpleGet)('EncounterMedication', {
    auditAccess: true
}));
medication.put('/:id', (0, _crudHelpers.simplePut)('EncounterMedication'));
medication.post('/$', (0, _crudHelpers.simplePost)('EncounterMedication'));
const globalMedicationRequests = (0, _crudHelpers.permissionCheckingRouter)('list', 'EncounterMedication');
globalMedicationRequests.get('/$', (req, res, next)=>(0, _crudHelpers.paginatedGetList)('EncounterMedication', '', {
        additionalFilters: {
            '$encounter.location.facility.id$': req.query.facilityId
        },
        include: [
            {
                model: req.models.Encounter,
                as: 'encounter',
                include: [
                    {
                        model: req.models.Patient,
                        as: 'patient'
                    },
                    {
                        model: req.models.Department,
                        as: 'department'
                    },
                    {
                        model: req.models.Location,
                        as: 'location',
                        include: [
                            {
                                model: req.models.Facility,
                                as: 'facility'
                            },
                            {
                                model: req.models.LocationGroup,
                                as: 'locationGroup'
                            }
                        ]
                    }
                ]
            }
        ]
    })(req, res, next));
medication.use(globalMedicationRequests);

//# sourceMappingURL=medication.js.map