"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "importerRouter", {
    enumerable: true,
    get: function() {
        return importerRouter;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _importerEndpoint = require("./importerEndpoint");
const _programImporter = require("../programImporter");
const _referenceDataImporter = require("../referenceDataImporter");
const _surveyResponsesImporter = require("../surveyResponsesImporter");
const _insurerPaymentImporter = require("../invoice/insurerPaymentImporter");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const importerRouter = _express.default.Router();
importerRouter.post('/program', (0, _importerEndpoint.createDataImporterEndpoint)(_programImporter.programImporter));
importerRouter.post('/referenceData', (0, _importerEndpoint.createDataImporterEndpoint)(_referenceDataImporter.referenceDataImporter));
importerRouter.post('/surveyResponses', (0, _importerEndpoint.createDataImporterEndpoint)(_surveyResponsesImporter.surveyResponsesImporter));
importerRouter.post('/insurerPayments', (0, _importerEndpoint.createDataImporterEndpoint)(_insurerPaymentImporter.insurerPaymentImporter));

//# sourceMappingURL=importerRouter.js.map