"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "fhirRoutes", {
    enumerable: true,
    get: function() {
        return fhirRoutes;
    }
});
const _express = require("express");
const _routeHandlers = require("./routeHandlers");
const _materialised = require("./materialised");
const _requireClientHeaders = require("../middleware/requireClientHeaders");
function fhirRoutes(ctx, { requireClientHeaders } = {}) {
    const routes = (0, _express.Router)();
    if (requireClientHeaders) {
        routes.use(_requireClientHeaders.requireClientHeaders);
    }
    // temporary: will replace this entire route once done
    routes.use('/mat', (0, _materialised.fhirRoutes)(ctx));
    routes.get('/Patient', (0, _routeHandlers.patientHandler)());
    routes.get('/DiagnosticReport', (0, _routeHandlers.diagnosticReportHandler)());
    routes.get('/Immunization', (0, _routeHandlers.immunizationHandler)());
    routes.get('/Patient/:id', (0, _routeHandlers.singlePatientHandler)());
    routes.get('/DiagnosticReport/:id', (0, _routeHandlers.singleDiagnosticReportHandler)());
    routes.get('/Immunization/:id', (0, _routeHandlers.singleImmunizationHandler)());
    return routes;
}

//# sourceMappingURL=index.js.map